/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.event;

import com.renyigesai.immortalers_delight.entities.living.SkelverfishBase;
import com.renyigesai.immortalers_delight.entities.living.SkelverfishBomber;
import com.renyigesai.immortalers_delight.entities.living.illager_archaeological_team.Scavenger;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightEntities;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightItems;
import com.renyigesai.immortalers_delight.util.WorldUtils;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class SkelverfishEventHelper {
    public static final String PILLAGER_HAS_KNIFE = "immortalers_delight_has_pillager_knife";

    @SubscribeEvent
    public static void onExplosionDamage(LivingHurtEvent event) {
        Entity entity;
        if (event.getSource().m_269533_(DamageTypeTags.f_268415_) && (entity = event.getSource().m_7639_()) instanceof SkelverfishBomber) {
            SkelverfishBomber bomber = (SkelverfishBomber)entity;
            float f = event.getEntity().m_217043_().m_188501_();
            float extraDamage = ((float)bomber.getMaxFireDamage() + (float)(bomber.m_21051_(Attributes.f_22281_) == null ? 0.0 : bomber.m_21051_(Attributes.f_22281_).m_22135_())) * (bomber.isPowered() ? 4.0f : 2.0f) + (bomber.m_9236_().m_46791_() == Difficulty.EASY ? 2.0f + f * 1.5f : 0.0f) + (bomber.m_9236_().m_46791_() == Difficulty.NORMAL ? 5.0f + f * 4.0f : 0.0f) + (bomber.m_9236_().m_46791_() == Difficulty.HARD ? 6.0f + f * 3.0f : 0.0f);
            event.setAmount(event.getAmount() + extraDamage);
        }
    }

    @SubscribeEvent
    public static void onAmbusherAttack(LivingHurtEvent event) {
        int hurtArmor;
        String idString;
        LivingEntity attacker;
        ResourceLocation entityId;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity && (entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)(attacker = (LivingEntity)entity).m_6095_())) != null && !attacker.m_9236_().f_46443_ && (idString = entityId.toString()).equals(ImmortalersDelightEntities.SKELVERFISH_AMBUSHER.getId().toString()) && (hurtArmor = event.getEntity().m_21230_()) > 0) {
            if (hurtArmor > 20) {
                hurtArmor = 20;
            }
            float damageBuffer = 1.0f / (1.0f - (float)hurtArmor * 0.04f) > 3.0f ? 3.0f : 1.0f / (1.0f - (float)hurtArmor * 0.04f);
            event.setAmount(event.getAmount() * damageBuffer);
        }
    }

    @SubscribeEvent
    public static void onThrasherJoinWorld(EntityJoinLevelEvent event) {
        Level level;
        Pillager pillager;
        Entity entity = event.getEntity();
        if (entity instanceof Sniffer) {
            Sniffer sniffer = (Sniffer)entity;
            sniffer.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)sniffer, 3.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ImmortalersDelightItems.SACHETS.get()}), false));
        }
        if ((entity = event.getEntity()) instanceof Pillager && (pillager = (Pillager)entity).m_37886_() && (level = pillager.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int r = pillager.m_217043_().m_188503_(3);
            if (r == 0) {
                Scavenger scavenger = new Scavenger((EntityType<? extends Scavenger>)((EntityType)ImmortalersDelightEntities.SCAVENGER.get()), pillager.m_9236_());
                scavenger.m_37851_(pillager.m_37885_());
                scavenger.m_6518_((ServerLevelAccessor)serverLevel, pillager.m_9236_().m_6436_(pillager.m_20183_()), MobSpawnType.SPAWNER, null, null);
                scavenger.m_7678_(pillager.m_20185_(), pillager.m_20186_(), pillager.m_20189_(), pillager.m_146908_(), pillager.m_146909_());
                pillager.m_9236_().m_7967_((Entity)scavenger);
            }
            if (r == 1 && pillager.m_21120_(InteractionHand.OFF_HAND).m_41619_()) {
                ItemStack mainHand;
                ItemStack knife = new ItemStack((ItemLike)ImmortalersDelightItems.PILLAGER_KNIFE.get());
                int i = pillager.m_217043_().m_188503_(4);
                if (i == 0) {
                    PotionUtils.m_43549_((ItemStack)knife, (Potion)Potions.f_43584_);
                }
                if (i == 1) {
                    PotionUtils.m_43549_((ItemStack)knife, (Potion)Potions.f_43593_);
                }
                if (i == 2) {
                    PotionUtils.m_43549_((ItemStack)knife, (Potion)Potions.f_43582_);
                }
                if (i == 3) {
                    PotionUtils.m_43549_((ItemStack)knife, (Potion)Potions.f_43615_);
                }
                if ((mainHand = pillager.m_21120_(InteractionHand.MAIN_HAND)).m_150930_(Items.f_42717_)) {
                    pillager.m_8061_(EquipmentSlot.MAINHAND, knife);
                    pillager.m_8061_(EquipmentSlot.OFFHAND, mainHand);
                } else {
                    pillager.m_8061_(EquipmentSlot.OFFHAND, knife);
                }
                CompoundTag entityTag = pillager.getPersistentData();
                entityTag.m_128405_(PILLAGER_HAS_KNIFE, 1);
            }
        }
    }

    @SubscribeEvent
    public static void onPillagerDeath(LivingDropsEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity deceased = event.getEntity();
        Level level = deceased.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            level = event.getSource().m_7639_();
            if (level instanceof Player) {
                ResourceLocation resourcelocation;
                Player player = (Player)level;
                CompoundTag entityTag = deceased.getPersistentData();
                if (entityTag.m_128425_(PILLAGER_HAS_KNIFE, 3) && entityTag.m_128451_(PILLAGER_HAS_KNIFE) > 0 && !(resourcelocation = new ResourceLocation("immortalers_delight", "entities/pillager_knife_loot")).equals((Object)BuiltInLootTables.f_78712_)) {
                    LootParams.Builder lootparams$builder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)deceased.m_20097_())).m_287286_(LootContextParams.f_81457_, (Object)event.getSource()).m_287286_(LootContextParams.f_81455_, (Object)event.getEntity()).m_287289_(LootContextParams.f_81456_, (Object)player).m_287289_(LootContextParams.f_81458_, (Object)player).m_287289_(LootContextParams.f_81459_, (Object)event.getSource().m_7640_());
                    LootParams lootparams = lootparams$builder.m_287235_(LootContextParamSets.f_81415_);
                    LootTable loottable = serverLevel.m_7654_().m_278653_().m_278676_(resourcelocation);
                    for (int i = 0; i < entityTag.m_128451_(PILLAGER_HAS_KNIFE); ++i) {
                        Object items = loottable.m_287195_(lootparams);
                        if (items.isEmpty()) {
                            items = WorldUtils.getFromLootTableItemStack(WorldUtils.getLootTables("immortalers_delight:entities/pillager_knife_loot", (Level)serverLevel), (Level)serverLevel, deceased.m_20097_().m_7494_());
                        }
                        for (ItemStack itemstack : items) {
                            event.getDrops().add(new ItemEntity(deceased.m_9236_(), deceased.m_20185_(), deceased.m_20186_(), deceased.m_20189_(), itemstack));
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPillagerHurt(LivingHurtEvent event) {
        LivingEntity attacker;
        Entity entity;
        Pillager hurtOne;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Pillager && !(hurtOne = (Pillager)livingEntity).m_9236_().m_5776_() && (entity = event.getSource().m_7639_()) instanceof LivingEntity && (attacker = (LivingEntity)entity).m_6336_() != MobType.f_21643_ && (double)hurtOne.m_20270_((Entity)attacker) <= 3.5 && (hurtOne.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)ImmortalersDelightItems.PILLAGER_KNIFE.get()) || hurtOne.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)ImmortalersDelightItems.PILLAGER_KNIFE.get()))) {
            float f = (float)(hurtOne.m_21051_(Attributes.f_22281_) == null ? 0.0 : hurtOne.m_21051_(Attributes.f_22281_).m_22135_());
            f += 3.0f;
            hurtOne.m_6674_(InteractionHand.MAIN_HAND);
            Vec3 hurtEntityPos = hurtOne.m_20182_();
            Vec3 sourceEntityPos = attacker.m_20182_();
            Vec3 directionVector = sourceEntityPos.m_82546_(hurtEntityPos);
            for (int i = 1; i <= 3; ++i) {
                attacker.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123766_, (hurtEntityPos.f_82479_ + sourceEntityPos.f_82479_) / 2.0, (hurtEntityPos.f_82480_ + sourceEntityPos.f_82480_) / 2.0, (hurtEntityPos.f_82481_ + sourceEntityPos.f_82481_) / 2.0, 0.2 * (double)i, 0.2 * (double)i, 0.2 * (double)i);
            }
            attacker.m_6469_(hurtOne.m_269291_().m_269333_((LivingEntity)hurtOne), f);
            attacker.m_20256_(hurtOne.m_20184_().m_82549_(directionVector));
        }
    }

    @SubscribeEvent
    public static void onSilverfishsIntoStone(EntityMobGriefingEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof SkelverfishBase) {
            SkelverfishBase skelverfishBase = (SkelverfishBase)entity;
            event.setResult(Event.Result.DENY);
        }
    }
}

